<?php

class db_functions
{	
	//class variable that represents the database connection.
	var $conn;
	var $lang;
	var $tblprefix;
	
	var $table_bgcolor,$cellspacing,$cellpadding,$border_style,$border_width,
	$border_color,$header_rowcolor,$header_text_color,$headerfont_face,$headerfont_size,
	$rowcolor,$rowcolor2,$rowcolor_text,$rowfont_face,$rowfont_size;
	
	//user-defined constructor
	public function __construct($server,$username,$password,$database,$tableprefix,$theme,$language)
	{
		//pre: parameters must be correct in order to connect to database.
		//post: connects to database.
		
		$this->conn = mysqli_connect($server, $username, $password);//, $database);
		if (mysqli_connect_errno()){
			echo "Failed to connect to MySQL: " . mysqli_connect_error();
			exit();
		}
		mysqli_select_db($this->conn,$database);
		mysqli_set_charset($this->conn,'UTF8');	
		
		switch($theme)
		{
			//add more themes
			
			case $theme=='serious':
				$this->table_bgcolor='white';
				$this->cellspacing='1';
				$this->cellpadding='0';
				$this->border_style='solid';
				$this->border_width='1';
				$this->border_color='black';
				
				$this->header_rowcolor='#660066';
				$this->header_text_color='white';
				$this->headerfont_face='arial';
				$this->headerfont_size='2';

				
				$this->rowcolor='#eefadf';
				$this->rowcolor_text='black';
				$this->rowfont_face='Verdana';
				$this->rowfont_size='2';
			break;
			
			case $theme=='big blue':
			
				$this->table_bgcolor='white';
				$this->cellspacing='1';
				$this->cellpadding='0';
				$this->border_style='solid';
				$this->border_width='1';
				$this->border_color='black';
				
				$this->header_rowcolor='navy';
				$this->header_text_color='white';
				$this->headerfont_face='arial';
				$this->headerfont_size='2';

				
				$this->rowcolor='#15759B';
				$this->rowcolor_text='white';
				$this->rowfont_face='geneva';
				$this->rowfont_size='2';
				
				
			break;
		
		}
	}
	
	function getUserID($username,$password)
	{
		//pre: $username is a string and $password (encrypted) is the user's encrypted password.
		//post: returns the id of the user with the specific username and password supplied.
		
		$tablename = "$this->tblprefix".'users';
		$result = mysqli_query($this->conn,"SELECT * FROM $tablename WHERE username=\"$username\" and password=\"$password\"");
		$row = mysqli_fetch_assoc($result);
		
		return $row['id'];
	}
	
	function getAllElements($tablename,$field,$orderby)
	{
		//pre: $tablename,$field,$orderby must be valid
		/*post: returns all elements in an array of specified table
		and sets first position to an empty string.  This function will be used for filling
		select fields, which requires the first position for the selected value
		*/

		$tables_c_sat = array("c_ClaveProdServ", "c_ClaveUnidad", "c_FormaPago", "c_UsoCFDI", "c_TipoRelacion", "c_RegimenFiscal");
		if($tablename == "branches")
			$fieldMostrar = "statusb";
		else
			$fieldMostrar = "mostrar";
		$tablenames = array( "branches", "categories", "items", "c_ClaveProdServ", "c_ClaveUnidad", "c_FormaPago", "c_UsoCFDI", "c_TipoRelacion", "c_RegimenFiscal");
		if (in_array($tablename, $tablenames))
		{
			$where = "WHERE $fieldMostrar = 1";
		}
		elseif ($tablename == "facturas_canceladas")
		{
			//$field = "DISTINCT(".$field.") AS uuid";
			$where = "WHERE res_codigo = 0";
		}
		if (in_array($tablename, $tables_c_sat)) 
		{
			$select_plus = ",".$tablename;
		}
		$query = "SELECT $field$select_plus FROM $tablename $where ORDER BY $orderby";
		$result = mysqli_query($this->conn,$query);
		$numRows = mysqli_num_rows($result);
		$data = array();
		
		while($row = mysqli_fetch_array($result)){
			if (in_array($tablename, $tables_c_sat))
			{
				if ($tablename == $tables_c_sat[2] || $tablename == $tables_c_sat[3] || $tablename == $tables_c_sat[4]) 
				{
					array_push($data,$row[$field]); 
				}
				else
				{
					array_push($data,$row[$field]." (".$row[$tablename].")");
				}
			}
			else
			{
				array_push($data,utf8_encode($row[$field])); 
			}
		}
		//if ($tablename == "facturas_canceladas") array_push($data,utf8_encode($query));
		return $data;
	}
	
	function idToField($tablename,$field,$id)
	{
		//pre: $tablename, field, and id all must be valid
		//post: returns a specified field based on the ID from a specified table.
		
		$result = mysqli_query($this->conn,"SELECT $field FROM $tablename WHERE id=\"$id\"");
		
		$row = mysqli_fetch_assoc($result);
		
		return $row[$field];
	}
	
	function idToFieldc($tablename,$field,$id,$cid)
	{
		//pre: $tablename, field, and id all must be valid
		//post: returns a specified field based on the ID from a specified table.
		
		$result = mysqli_query($this->conn,"SELECT $field FROM $tablename WHERE item_id=\"$id\" and color_id=\"$cid\"");
		
		$row = mysqli_fetch_assoc($result);
		
		return $row[$field];
	}
	
	function fieldToid($tablename,$field,$value)
	{
		//pre: $tablename, field, and value all must be valid
		//post: returns a specified id based on the field from a specified table.

		$result = mysqli_query($this->conn,"SELECT * FROM $tablename WHERE $field=\"$value\"");
		
		$row=mysqli_fetch_assoc($result);
		
		return $row['id'];

	}
	
	function getFields($database,$tablename)
	{	
		//returns fields in table
	
		$fields=array();
		$fieldsRef=mysql_list_fields ($database, $tablename);
		$columns=mysql_num_fieldsfieldsRef;
		
		for($k=0;$k<$columns;$k++)
		{
			$fields[]=mysql_field_name($fieldsRef,$k);
		}

		return $fields;
	}
	
	function userActivities($date,$user,$time,$action,$where,$ubranch_id)
	{
		$field_names=array('date','user_name','time','action','location','branch_id');
		$field_data=array("$date","$user","$time","$action","$where","$ubranch_id");
		
		$this->insert($field_names,$field_data,'user_activities',false);	
		 			
	}
	
	function inventoryCalculation($tablename,$branch_id,$item_id)
	{
		$result = mysqli_query($this->conn,"SELECT stock FROM inventory WHERE branch_id=\"$branch_id\" AND item_id=\"$item_id\" ORDER BY id DESC LIMIT 1");
		
		$row = mysqli_fetch_assoc($result);
		
		return $row['stock'];
	
	}
	function insert($field_names,$field_data,$tablename,$output = null)			// Actualizada!
	{
		if(!($this->isValidData($field_data)))
		{
			echo "{$this->lang->invalidCharactor}";
			exit();
		}
		$query = "INSERT INTO $tablename ($field_names[0]";
			
		for($k=1;$k< count($field_names);$k++)
		{
			$query.=', '."$field_names[$k]";
		}
		$query.=") VALUES (\"".$field_data[0]."\"";
		
		for($k=1;$k< count($field_data);$k++)
		{
			$query.=", \"".$field_data[$k]."\"";
		}
		$query.=')';
		//if ($tablename == "facturas_canceladas") echo $query;
		mysqli_query($this->conn,$query);
		if($output)
		{
			$this->outputTableQuery($field_names,$field_data,$tablename);
		}
	}
	function update($field_names,$field_data,$tablename,$id,$output = null)		// Actualizada!
	{		
		if($id=='')
		{
			echo "{$this->lang->didNotEnterID}";
			exit();
		}
		if(!($this->isValidData($field_data)))
		{
			echo "{$this->lang->invalidCharactor}";
			exit();
		}
		$query="UPDATE $tablename SET $field_names[0]=\"".$field_data[0]."\"";
		for($k=1;$k< count($field_names);$k++)
		{
			$query.=', '."$field_names[$k]=\"$field_data[$k]\"";
		}
		$sales_items_table=$this->tblprefix.'sales_items_ps';
		if($output)
		{
			$query.=" WHERE id=\"$id\"";
		}
		else
		{
			$query.=" WHERE sale_id=\"$id\"";
		}
		mysqli_query($this->conn,$query);
		if($output)
		{
			$this->outputTableQuery($field_names,$field_data,$tablename);
		}
	}
	function outputTableQuery($field_names,$field_data,$tablename)			// NUEVA!
	{
		echo "
<div class='container clearfix'>
	<div class='modal-content' style= 'margin-top: 30px;'>
		<div class='modal-header' style='background-color: #660066;'>
			<h4 class='modal-title' style='color: #FFFFFF; text-transform: uppercase;'><i class='icon-line-square-plus'></i> {$this->lang->successfullyAdded} $tablename</h4>
		</div>
		<div class='modal-body'>
			<div class='contact-widget'>
				<table class='table table-striped'>
					<thead>
						<tr>
							<th>{$this->lang->field}</th>
							<th>{$this->lang->data}</th>
						</tr>
					</thead>
					<tbody>";
		for($k=0;$k<count($field_names);$k++)
		{
			echo "
						<tr>
							<td>$field_names[$k]</td>";
			if($field_names[$k]!="password")
				echo "
							<td>$field_data[$k]</td>";
			else
				echo "
							<td>***********</td>";
			echo "
						</tr>";
		}
				echo "
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>";
	}	
	function updatebuys($field_names,$field_data,$tablename,$id,$output)
	{
		//pre: $field_names and $field_data are pararell arrays and tablename and id are strings.
		//post: creates a query then executes it limites based on id.
		
		if($id=='')
		{
			echo "{$this->lang->didNotEnterID}";
			exit();
		}
		if(!($this->isValidData($field_data)))
		{
			echo "{$this->lang->invalidCharactor}";
			exit();
		}
			$query="UPDATE $tablename SET $field_names[0]=\"$field_data[0]\"";
			
		for($k=1;$k< count($field_names);$k++)
		{
			$query.=', '."$field_names[$k]=\"$field_data[$k]\"";
		
		}
		
			$sales_items_table=$this->tblprefix.'sales_items_ps';
			$buys_items_table=$this->tblprefix.'buys_items_ps';
			
			if($output)
			{
				 $query.=" WHERE id=\"$id\"";
							
			}
			else
			{
				$query.=" WHERE buy_id=\"$id\"";
							
			}
			
			
			
					
			mysqli_query($this->conn,$query);
	
	
		if($output)
		{
			echo "<center><b>{$this->lang->successfullyUpdated} $tablename</b></center><br>";
				
				echo "<center><table width=350 cellspacing=$this->cellspacing cellpadding=$this->cellpadding bgcolor=$this->table_bgcolor style=\"border: $this->border_style $this->border_color $this->border_width px\">
				<tr bgcolor=$this->header_rowcolor>
				<th align='left'><font color='$this->header_text_color' face='$this->headerfont_face' size='$this->headerfont_size'>{$this->lang->field}</th></font>
				<th align='left'><font color='$this->header_text_color' face='$this->headerfont_face' size='$this->headerfont_size'>{$this->lang->data}</th></font>
				</tr>";
				for($k=0;$k<count($field_names);$k++)
				{
					//certain fields I do not want displayed.
					if($field_names[$k]!="password")
					{
						echo "<tr bgcolor=$this->rowcolor><td width='120'><font color='$this->rowcolor_text' face='$this->rowfont_face' size='$this->rowfont_size'>$field_names[$k]". '</font></td>'."<td><font color='$this->rowcolor_text' face='$this->rowfont_face' size='$this->rowfont_size'>$field_data[$k]</font></td></tr>\n";
					}
					else
					{
						echo "<tr bgcolor=$this->rowcolor><td width='120'><font color='$this->rowcolor_text' face='$this->rowfont_face' size='$this->rowfont_size'>$field_names[$k]". '</font></td>'."<td><font color='$this->rowcolor_text' face='$this->rowfont_face' size='$this->rowfont_size'>*******</font></td></tr>\n";
					
					}
				}
				echo '</table></center>';
	
		}
	}	
	
	
	function deleteRow($tablename,$id)
	{
		//pre: $tablename and id are strings.
		//post: Does extensive error checking and then deletes row is allowed.
		
		if($this->tblprefix=='')
		{
			$baseTable=$tablename;
		}
		else
		{
			$splitTable= explode ("$this->tblprefix",$tablename);
			$baseTable=$splitTable[1];
		}
			
		$canDelete=true;
		$errmessage='';
		
		if($id=='')
		{
			echo "{$this->lang->didNotEnterID}";
			exit();
		}
		elseif($baseTable=='brands')
		{

			$checkTable = "$this->tblprefix".'items';
			$result = mysqli_query($this->conn,"SELECT brand_id FROM $checkTable WHERE brand_id=\"$id\"");
			if(@mysqli_num_rows($result) >= 1)
			{ 
				$canDelete=false;
				$errmessage="{$this->lang->cantDeleteBrand}";

			} 	
		
		}
		elseif($baseTable=='categories')
		{
			$checkTable = "$this->tblprefix".'items';
			$result = mysqli_query($this->conn,"SELECT category_id FROM $checkTable WHERE category_id=\"$id\"");
			
			if(@mysqli_num_rows($result) >= 1)
			{
				$canDelete=false;	
				$errmessage="{$this->lang->cantDeleteCategory}";

			} 	
		
		}
		elseif($baseTable=='customers')
		{
			$checkTable = "$this->tblprefix".'sales_ps';
			$result = mysqli_query($this->conn,"SELECT customer_id FROM $checkTable WHERE customer_id=\"$id\"");
			
			if(@mysqli_num_rows($result) >= 1)
			{
				$canDelete=false;
				$errmessage="{$this->lang->cantDeleteCustomer}";
			} 	
		
		}
		elseif($baseTable=='items')
		{
			$checkTable = "$this->tblprefix".'sales_items_ps';
			$result = mysqli_query($this->conn,"SELECT item_id FROM $checkTable WHERE item_id=\"$id\"");
			
			if(@mysqli_num_rows($result) >= 1)
			{
				$canDelete=false;
				$errmessage="{$this->lang->cantDeleteItem}";
			} 	
		
		}
		elseif($baseTable=='suppliers')
		{

			$checkTable = "$this->tblprefix".'items';
			$result = mysqli_query($this->conn,"SELECT supplier_id FROM $checkTable WHERE supplier_id=\"$id\"");
			if(@mysqli_num_rows($result) >= 1)
			{ 
				$canDelete=false;
				$errmessage="{$this->lang->cantDeleteSupplier}";

			} 	
		
		}
		elseif($baseTable=='sales')
		{
			$sales_items_table="$this->tblprefix".'sales_items_ps';
			$items_table="$this->tblprefix".'items';
			$result=mysqli_query($this->conn,"SELECT * FROM $sales_items_table WHERE sale_id=\"$id\"");
			
			while($row=mysqli_fetch_assoc($result))
			{
				$quantityToAdd =$row['quantity_purchased'];
				$newQuantity=$this->idToField($items_table,'quantity',"$row[item_id]")+$quantityToAdd;
				$this->updateItemQuantity($row['item_id'],$newQuantity);
			}
		    mysqli_query($this->conn,"DELETE FROM $sales_items_table WHERE sale_id=\"$id\"");	
		}
		elseif($baseTable=='users')
		{
			
			$checkTable = "$this->tblprefix".'sales_ps';

			$result = mysqli_query($this->conn,"SELECT sold_by FROM $checkTable WHERE sold_by=\"$id\"");
			if($_SESSION['session_user_id']==$id)
			{
				$canDelete=false;
				$errmessage="{$this->lang->cantDeleteUserLoggedIn}";
	

			}
			elseif(@mysqli_num_rows($result) >= 1)
			{
				$canDelete=false;
				$errmessage="{$this->lang->cantDeleteUserEnteredSales}";
			}
			
			
				
		} 	
		
		if($canDelete==true)
		{
			$query="DELETE FROM $tablename WHERE id=\"$id\"";
			mysqli_query($this->conn,$query);
	
			echo "<center>{$this->lang->successfullyDeletedRow} <b>$id</b> {$this->lang->fromThe} <b>$tablename</b> {$this->lang->table}</center>";
		}
		else
		{
			echo "<center>$errmessage</center><br>";
		}
	}
	
	
	function isValidData($data_to_check)
	{
		//checks data for errors
	
		for($k=0;$k<count($data_to_check);$k++)
		{
			if(preg_match('/\"/',$data_to_check[$k]) or preg_match('/</',$data_to_check[$k]) or preg_match('/>/',$data_to_check[$k]) )
			{
				return false;
			}
		}
		
		return true;
	
	}
	
	function isValidItem($item)
	{
		$table=$this->tblprefix.'items';
		$result=mysqli_query($this->conn,"SELECT id FROM $table WHERE id=\"$item\"");
		
		if(mysqli_num_rows($result)==0)
		{
			return false;
		}
		
		return true;
	}
	
	function isItemOnDiscount($itemID)
	{
		$table=$this->tblprefix.'discounts_ps';
		$query="SELECT item_id FROM $table WHERE item_id=\"$itemID\"";
		$result=mysqli_query($this->conn,$query);
		
		if(mysqli_num_rows($result) >0)
		{
			return true;
		}
		return false;

	}
	
	function getPercentDiscount($itemID)
	{
		$table=$this->tblprefix.'discounts_ps';
		$query="SELECT percent_off FROM $table WHERE item_id=\"$itemID\"";
		$result=mysqli_query($this->conn,$query);
		
		if(mysqli_num_rows($result) >0)
		{
			$row=mysqli_fetch_assoc($result);
			return $row['percent_off'];
		}
		return -1;
	}
	
	function getDiscountedPrice($itemID)
	{
		$itemtable=$this->tblprefix.'items';
		$discounttable=$this->tblprefix.'discounts_ps';
		
		$query1="SELECT * FROM $discounttable WHERE item_id=\"$itemID\"";
		$row=mysqli_fetch_assoc(mysqli_query($this->conn,$query1));
		$percent_off=$row['percent_off'];
		
		$query2="SELECT * FROM $itemtable WHERE id=\"$itemID\"";
		$row=mysqli_fetch_assoc(mysqli_query($this->conn,$query2));
		$discounted_price=$row['unit_price']*(1-($percent_off/100));
		
		return number_format($discounted_price,2,'.', '');

		

	}
	
		function validXMLdata($cadena)
	{
		
		$incorrectas = array("", "", "\"",">","<","&","","","","","","","","","","","");
		$correctas = array("&ntilde;", "&Ntilde;", "&quot;","&gt;","&lt","&amp;","&aacute;","&eacute;","&iacute;","&oacute;","&uacute;","&Aacute;","&Eacute;","&Iacute;","&Oacute;","&Uacute;"," ");

		$data = str_replace($incorrectas, $correctas, $cadena);
		
		return $data;
		
		
		//return $cadena;

	}
	
	function isValidCustomer($customer)
	{
		$table=$this->tblprefix.'customers';
		$result=mysqli_query($this->conn,"SELECT id FROM $table WHERE id=\"$customer\"");
		
		if(mysqli_num_rows($result)==0)
		{
			return false;
		}
		
		return true;
	}
	
	function isValidSupplier($supplier)
	{
		$table=$this->tblprefix.'suppliers';
		$result=mysqli_query($this->conn,"SELECT id FROM $table WHERE id=\"$supplier\"");
		
		if(mysqli_num_rows($result)==0)
		{
			return false;
		}
		
		return true;
	}	
	function getNumRows($table)
	{
		//gets the number of rows in a table
		
		$query="SELECT id FROM $table";
		$result=mysqli_query($this->conn,$query);
		
		return mysqli_num_rows($result);
	
	}
	
	
	
	function updateSaleTotals($sale_id)
	{
		//updates the totals for a sale
		
		$sales_items_table=$this->tblprefix.'sales_items_ps';
		$sales_table=$this->tblprefix.'sales_ps';
		
		$query="SELECT item_total_cost,item_total_tax,quantity_purchased FROM $sales_items_table WHERE sale_id=\"$sale_id\"";
		
		$result=mysqli_query($this->conn,$query);
		
		
		
		if(@mysqli_num_rows($result) > 0)
		{
			$sale_sub_total=0;
			$sale_total_cost=0;
			$items_purchased=0;
		
			while($row=mysqli_fetch_assoc($result))
			{
				$sale_sub_total+=$row['item_total_cost']-$row['item_total_tax'];
				$sale_total_cost+=$row['item_total_cost'];
				$items_purchased+=$row['quantity_purchased'];
			}
			
			$sale_sub_total=number_format($sale_sub_total,2,'.', '');
			$sale_total_cost=number_format($sale_total_cost,2,'.', '');
			
			$query2="UPDATE $sales_table SET sale_sub_total=\"$sale_sub_total\",sale_total_cost=\"$sale_total_cost\",items_purchased=\"$items_purchased\" WHERE id=\"$sale_id\"";
			mysqli_query($this->conn,$query2);
		}
		else
		{
			$this->deleteRow($sales_table,$sale_id);	
		}
	}
	
	function updateItemQuantity($item_id,$newQuantity)
	{
		$items_table=$this->tblprefix.'items';
		$query="UPDATE $items_table SET quantity=\"$newQuantity\" WHERE id=\"$item_id\"";
		mysqli_query($this->conn,$query);
		
	}
	
	function optimizeTables()
	{
		//optimizes the sales
		
		$tableprefix=$this->tblprefix;
		$brandsTable="$tableprefix".'brands';
		$categorieTable="$tableprefix".'categories';
		$customersTable="$tableprefix".'customers';
		$itemsTable="$tableprefix".'items';
		$salesTable="$tableprefix".'sales_ps';
		$sales_itemsTable="$tableprefix".'sales_items_ps';
		$suppliersTable="$tableprefix".'suppliers';
		$usersTable="$tableprefix".'users';

		$query="OPTIMIZE TABLE $brandsTable, $categorieTable, $customersTable, $itemsTable, $salesTable, $sales_itemsTable,$suppliersTable, $usersTable";
		mysqli_query($this->conn,$query);
	}
	
	function extract_number($string)
	{
		$cadena ='';
		$number = '';
		$cadena = $string;
			for($i=0;$i<=strlen($cadena);$i++)
			{
				if(is_numeric($cadena[$i]) || $cadena[$i]=="-")
				{
					$number.=$cadena[$i];
				}		
			}
		
		if($number=='')
		{
			$number="-";
		}
		
		return $number;
		//return $string;
	}
	
	function replace_empty($string)
	{
		if($string=="")
		{
			$string = "-";
		}
		return $string;
	}
	
	function uploader($type, $dir){
	$num_of_uploads=1;
	$max_file_size=1048576;
	$file_types_array=array("$type");
	$upload_dir="../files/$dir/";
  if(!is_numeric($max_file_size)){
    $max_file_size = 1048576;
  }
  if(!isset($_POST["submitted"])){
  	if($dir=='folios')
	 {
    	$form = "<form action='".$_SERVER['PHP_SELF']."' method='post' enctype='multipart/form-data' id='myform'><font color='white'>  <br> Numero de Aprobaci&oacute;n*:&nbsp;<input type='text' name='num_aprobacion' size='25'></br><br> Ao de Aprobaci&oacute;n*:&nbsp;<input type='text' name='year_aprob' size='25'></br><br>Seleccione un Archivo:</br></font><br /><input type='hidden' name='submitted' value='TRUE' id='".time()."'><input type='hidden' name='MAX_FILE_SIZE' value='".$max_file_size."'>";
	 }
	else
		{
			$form = "<form action='".$_SERVER['PHP_SELF']."' method='post' enctype='multipart/form-data' id='myform'><font color='white'> Seleccione un archivo:</font><br /><input type='hidden' name='submitted' value='TRUE' id='".time()."'><input type='hidden' name='MAX_FILE_SIZE' value='".$max_file_size."'>";	
		}
    for($x=0;$x<$num_of_uploads;$x++){
      $form .= "<input type='file' name='file[]'><font color='red'>*</font><br />";
    }
    
	if($dir=='key')
	{
	$form .= "<font color='white'> <br> Password: &nbsp;</h6><input type='password' name='key_pass' size='10'></br><input type='submit' value='Upload'><br /><font color='red'>*</font><font color='white'>El tamao maximo de nombre para el archivo es de 30 caracteres. <br>El formato valido es: </font>";
	}
	else
	 {
	 	$form .= "<input type='submit' value='Upload'><br /><font color='red'>*</font><font color='white'>El tamao maximo de nombre para el archivo es de 30 caracteres. <br>El formato valido es: </font>";

	 }
	
    for($x=0;$x<count($file_types_array);$x++){
      if($x<count($file_types_array)-1){
        $form .= $file_types_array[$x].", ";
      }else{
        $form .= "." . $file_types_array[$x];
      }
    }
    $form .= "</form>";
    echo($form);
  }
    		 
  else{ 
  	$load=0;	
	if($dir=='cer' || $dir=='key')
		{
			$load=1;
		}
  	if(!empty($_POST['num_aprobacion']) and !empty($_POST['year_aprob']))
		{
			$load=2;
		}

  	if($load==1 || $load==2)
  	{ 	
  		foreach($_FILES["file"]["error"] as $key => $value)
			{
      			if($_FILES["file"]["name"][$key]!="")
					{
        				if($value==UPLOAD_ERR_OK)
							{
          						$origfilename = $_FILES["file"]["name"][$key];
          						$filename = explode(".", $_FILES["file"]["name"][$key]);
          						$filenameext = $filename[count($filename)-1];
          						unset($filename[count($filename)-1]);
          						$filename = implode(".", $filename);
          						$filename = substr($filename, 0, 30).".".$filenameext;
          						$file_ext_allow = FALSE;
          						for($x=0;$x<count($file_types_array);$x++)
									{
            							if($filenameext==$file_types_array[$x])
											{
              									$file_ext_allow = TRUE;
            								}
          							}
          						if($file_ext_allow)
									{
            							if($_FILES["file"]["size"][$key]<$max_file_size)
											{
              									if(move_uploaded_file($_FILES["file"]["tmp_name"][$key], $upload_dir.$filename))
													{
                										echo("El archivo se ha cargado exitosamente. - <a href='".$upload_dir.$filename."' target='_blank'>".$filename."</a><br />");
														if($dir=='folios')
														 {		
			   											if(!empty($_POST['num_aprobacion']) and ($_POST['year_aprob']))
			   												{	
															    $num_aprob=$_POST['num_aprobacion'];
																$year_aprob=$_POST['year_aprob'];		  		 
			  													$linkr="../classes/addfiles.php?num_aprob=$num_aprob&year_aprob=$year_aprob&type=$dir&name=$filename";
			  													$delay = "4"; 
			  													echo '<meta http-equiv="refresh" content="'.$delay.'; url='.$linkr.'">'; 
			  												}
																			
			  											else
			  												echo "Faltan campos obligatorios intente de nuevo";
														}
														else if($dir=='cer')
															{
																$linkr="../classes/addfiles.php?type=$dir&name=$filename";
			  													$delay = "4"; 
			  													echo '<meta http-equiv="refresh" content="'.$delay.'; url='.$linkr.'">';
															}
														else if($dir=='key')	
															{
															   $key_pass=$_POST['key_pass'];
																$linkr="../classes/addfiles.php?type=$dir&name=$filename&key_pass=$key_pass";
			  													$delay = "4"; 
			  													echo '<meta http-equiv="refresh" content="'.$delay.'; url='.$linkr.'">';
															}
														
														
														
															
              										}else
														{
               												echo($origfilename." no se pudo cargar el archivo<br />");
              											}
            								}else
												{
              										echo($origfilename." es muy grande, no se puede cargar<br />");
            									}
          								}else

											{
            									echo($origfilename." tiene una extension invalida, no se puede cargar<br />");
          									}
        							}else
										{
          									echo($origfilename." no se pudo cargar<br />");
        								}
      							}
   	 						}
  						} else
							{
							    if($dir=='folios')
								{
						    		echo "<center>Faltan uno o mas campos obligatorios<br>Espere sera redireccionado para que lo intente nuevamente</center>";
									$linkr=$_SERVER['PHP_SELF'];
			  						$delay = "4"; 
			  						echo '<meta http-equiv="refresh" content="'.$delay.'; url='.$linkr.'">';
								}	
									
					  }
							
		     }
						
   }

   function saleStatus($id_sale)
   {
   		$return = $id_sale;
   		$query = "SELECT id, id_sale_ant FROM sales WHERE id = ".$id_sale;
   		$result = mysqli_query($this->conn, $query);
   		if($row = mysqli_fetch_array($result))
   		{
   			$id_sale_ant = $row['id_sale_ant'];
   			if($id_sale_ant != "")
   			{
   				//$return .= $this->saleStatus($row['id_sale_ant']);
   				return $this->getStatus($id_sale);
   			}
   			else
   			{
   				return $this->saleStatus($id_sale_ant);
   			}

   			/*
   			else
			{
				//$status = "";
				$last_sale_id = explode(">", $return);
				for($r = 0; $r < count($last_sale_id); $r++)
				{
					$last_sale_id = $last_sale_id[$r];
					//$status .=  " >".$this->getStatus($last_sale_id);
					$return .=  " >".$this->getStatus($last_sale_id);
				}

				//return $status;
				return $return;
			}
			*/
   		}
   }

	function getStatus($last_sale_id)
	{
		$status = "";
   		$query = "SELECT status FROM sales WHERE id = ".$last_sale_id;
   		$result = mysqli_query($this->conn, $query);
   		
   		if($row = mysqli_fetch_array($result))
   		{
			switch ($row['status']) {
				case '0':
					$status = "Presupuesto";
				break;
				case '1':
					$status = "Cotizacion";
				break;
				case '2':
					$status = "Factura";
				break;
				case '4':
					$status = "Salida";
				break;
				/*
				default:
					$status .= $status;
				break;
				*/
			}

			return $status;
		}
	}

	function extractDataXML($timbre_fiscal, $key)
	{
		$timbre_fiscal = str_replace(array("<", "?", ">", "/>"),"",$timbre_fiscal);
		$pos = strpos($timbre_fiscal,  $key);			// Primer aparicin
		//$pos = strripos($timbre_fiscal,  $key);			// ltima aparicin
	
		$first = substr($timbre_fiscal, $pos);
		$first_array = explode("\"", $first);
		$data = $first_array[1];

		return $data;
	}
		
	function closeDBlink()
	{
		mysqli_close($this->conn);
	}

}
?>