<?php

class ConectorServisim{
	
	private $wsdl;
	
	private $user;
	private $pass;
	
	private $nameSpace;
	private $method;
	
	private $request;
	private $response;
	
	public function __construct(){
		$this->wsdl = null;
		$this->user = null;
		$this->pass = null;
		$this->nameSpace = null;
		$this->method = null;
	}
	
	public function establecerEndPoint($endPoint){
		$this->wsdl = $endPoint.'?wsdl';
	}
	
	public function establecerSoapAction($nameSpace, $method){
		$this->nameSpace = $nameSpace;
		$this->method = $method;
	}
	
	public function establecerAcceso($user, $pass){
		$this->user = $user;
		$this->pass = $pass;
	}
	
	public function crearPeticion(){
		$this->request = new StdClass();
	}
	
	public function asignarEnPeticion($name, $value){
		if($name == 'Id'){
			$this->request->id = $value;			
		}
		else if($name == 'Xml'){
			$this->request->xml = new SoapVar(utf8_encode('<xml><![CDATA['.$value.']]></xml>'), XSD_ANYXML);			
		}
	}
	
	public function consumirServicio(){
		try{		
			$cliente = new SoapClient($this->wsdl);
			$wsseHeader = '<wsse:Security SOAP-ENV:mustUnderstand="1" xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd" xmlns:wsu="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd">
				<wsse:UsernameToken>
				<wsse:Username>'.$this->user.'</wsse:Username>
				<wsse:Password Type="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText">'.$this->pass.'</wsse:Password>
				</wsse:UsernameToken>
				</wsse:Security>';		
			$varHeader = new SoapVar($wsseHeader, XSD_ANYXML, null, null, null);
			$header = new SoapHeader('http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd', 'wsse', $varHeader);
			$cliente->__setSoapHeaders(array($header));
			$result = $cliente->timbrarCFDi(array('RequestServisim'=>$this->request));
			$this->response = $result->ResponseServisim;
			$this->request = null;
		}
		catch (Exception $ex) {
			throw new Exception('Error al conectar con servicio web. '.$ex->getMessage());
		}
	}
	
	public function obtenerDeRespuesta($name){
		if($name == 'IdError'){
			return $this->response->idError;
		}
		else if($name == 'Error'){
			return $this->response->error;
		}
		else if($name == 'Uuid'){
			return $this->response->uuid;
		}
		else if($name == 'FechaTimbre'){
			return $this->response->fechaTimbre;
		}
		else if($name == 'Xml'){	
			return $this->response->xml;
		}
		else{
			return '';
		}
	}
}

?>