<?php 
//=======================================
// App Name:e-invox V 0.1
// File Name: xml.php
//---------------------------------------
// Description: 
// XML parser para CFDI
//=======================================
// Author: Juan Pablo Diaz Ezcurdia 
//---------------------------------------
// Contact:  jdiaz@postech.com.mx
// http://www.postech.com.mx
//=======================================

session_start();
date_default_timezone_set('UTC');

include ("../../settings.php");
include ("../../language/$cfg_language");
include ("../../classes/db_functions.php");
include ("../../classes/security_functions.php");


$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Public',$lang);

$sale_id= $_REQUEST['saleid'];
$sales_table = $cfg_tableprefix.'sales';
$sales_items_table = $cfg_tableprefix.'sales_items';
$customers_table = $cfg_tableprefix.'sales_customers';
$invoicer_table = $cfg_tableprefix.'invoicer';
$states_table = $cfg_tableprefix.'states';
$items_table = $cfg_tableprefix.'items';

# datos de venta
$sale_result = mysqli_query($dbf->conn,"SELECT * from $sales_table WHERE id=$sale_id") or die("No existen coincidencias para la venta num $sale_id.");

while($row = mysqli_fetch_array($sale_result))
{
	$tipo_pago=$row["tipo_pago"];
	$folio=$row["folio"];
	$datef=$row["date"];
	$timef=$row["sale_time"];
	$sale_subtotal=$row["sale_sub_total"];
	$sale_total_cost=$row["sale_total_cost"];
	$advance=$row["advance"];
	$datetimef="$datef$timef";
	$original_string=$row["cadena_original"];
	$sello=$row["sello"];
	$discount=$row["discount"];
	$paid_with = $row["paid_with"];
	$digitos_cuenta = $row["digitos_cuenta"];
}

# detalle de venta
$sales_items_result = mysqli_query($dbf->conn,"SELECT $sales_items_table.sale_id, $sales_items_table.quantity_purchased, $sales_items_table.item_unit_price, $sales_items_table.item_total_cost, $sales_items_table.temp_name, $sales_items_table.afecta, $sales_items_table.branch_id, $items_table.item_name, $items_table.item_number, $items_table.description, $items_table.id FROM $sales_items_table JOIN $items_table ON $sales_items_table.item_id = $items_table.id WHERE $sales_items_table.sale_id = $sale_id order by $sales_items_table.id");
	
# datos folios
$folios_header_result =mysqli_query($dbf->conn,"SELECT * FROM folios_header");

while($row = mysqli_fetch_array($folios_header_result))
{
	$ano_aprob=trim($row["ano_aprob"]);
	$serie_cert=trim($row["serie_cert"]);
	$num_aprob=trim($row["num_aprob"]);
	$certificado=trim($row["certificado"]);
}

# detalle de impuesto trasladado
$tax_items_result = mysqli_query($dbf->conn,"SELECT item_unit_price, item_total_cost, quantity_purchased,item_id FROM $sales_items_table WHERE sale_id = $sale_id order by $sales_items_table.id");

# datos de cliente
$customer_result = mysqli_query($dbf->conn,"SELECT * FROM $customers_table WHERE sale_id = $sale_id");
while($row = mysqli_fetch_array($customer_result))
{
	$customer_nameo=$row["name"];
	$customer_rfco=$row["rfc"];
	$customer_street_addresso=$row["street_address"];
	$customer_num_exto=$row["num_ext"];
	$customer_num_int=$row["num_int"];
	$customer_col=$row["col"];
	$customer_del=$row["del"];
	$customer_city=$row["city"];
	$customer_state_id=$row["state_id"];
	$customer_cp=$row["cp"];
	$customer_num=$row["id"];
}

#Quitamos espacion en blanco e innecesarios
$customer_name = trim($customer_nameo);
$customer_rfc = trim($customer_rfco);
$customer_street_address = trim($customer_street_addresso);
$customer_num_ext = trim($customer_num_exto);
$customer_state_name = $dbf->idToField($states_table,'state',$customer_state_id);

#si el numero interior esta vacio coloca una coma
if(empty($customer_num_int))
{
	$customer_num_int=",";
}

# datos de emisor fiscal
$invoicer_result = mysqli_query($dbf->conn,"SELECT * from $invoicer_table") or die("No existen informacion del emisor fiscal");
while($row = mysqli_fetch_array($invoicer_result))
{
	$invoicer=$row["razon_social"];
	$invoicer_rfc=$row["rfc"];
	$invoicer_street=$row["street"];
	$invoicer_no_exter=$row["no_exter"];
	$invoicer_no_inter=$row["no_inter"];
	$invoicer_colony=$row["colony"];
	$invoicer_delegation=$row["delegation"];
	$invoicer_cp=$row["cp"];
	$invoicer_country=$row["country"];
	$invoicer_city=$row["city"];
	$invoicer_state_id=$row["state_id"];
	$invoicer_phone_number=$row["phone_number"];
	$invoicer_id=$row["id"];
}
$invoicer_state_name = $dbf->idToField($states_table,'state',$invoicer_state_id);

# Reglas de parseo para formato de xml
$customer_name_p = trim($dbf->validXMLdata($customer_name));
$customer_rfc_p = trim($dbf->validXMLdata($customer_rfc));
$customer_street_address_p = trim($dbf->validXMLdata($customer_street_address));
$customer_col_p = trim($dbf->validXMLdata($customer_col));
$customer_del_p = trim($dbf->validXMLdata($customer_del));
$customer_city_p = trim($dbf->validXMLdata($customer_city));
$customer_state_name_p = trim($dbf->validXMLdata($customer_state_name));
$nowdt=$datef."T".$timef;

# Calculo de formas de pago por tipo
if ($tipo_pago ==1 or $tipo_pago ==3)
{
	$sale_subtotal=$sale_subtotal-$advance;
}
if ($tipo_pago ==2)
{
	unset($sale_subtotal,$sale_total_cost);
	$sale_subtotal=$advance;
	$ftax= $sale_subtotal*$cfg_default_tax_rate/100;
	$sale_total_cost=number_format($sale_subtotal+ $ftax,2,'.','');
}
if ($tipo_pago ==3)
{
	unset($sale_total_cost);
	$ftax= $sale_subtotal*$cfg_default_tax_rate/100;
	$sale_total_cost=$sale_subtotal+ $ftax;
}

header("Content-type: text/xml");
# Descuento
if($discount>0 and $tipo_pago<> 2)
{
	$xml_descuento = "descuento = \"$discount\" motivoDescuento=\"Descuento especial\"";
}
else
{
	$xml_descuento = "";
}

$metodo_pago = $paid_with;
$display_digitos_cuenta = '';

if($paid_with == '02' or $paid_with == '03' or $paid_with == '04' or $paid_with == '05' or $paid_with == '07'or $paid_with == '28' or $paid_with == '29' )
{
	trim($digitos_cuenta);
	if($digitos_cuenta != '')
	{
		$display_digitos_cuenta = "NumCtaPago=\"$digitos_cuenta\"";
	}
	else
	{
		$display_digitos_cuenta = "NumCtaPago=\"XXXX\"";
	}
}

//escribe la leyenda para el tipo de pago
if ($tipo_pago ==1)
{
	$tipo_pago_desc="PAGO EN UNA SOLA EXHIBICION";
}
if ($tipo_pago ==2)
{
	$tipo_pago_desc="ANTICIPO";
}
$xml_output = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r";
$xml_output .= "<cfdi:Comprobante xmlns:cfdi=\"http://www.sat.gob.mx/cfd/3\" xmlns:tfd=\"http://www.sat.gob.mx/TimbreFiscalDigital\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" LugarExpedicion=\"Mexico\" tipoDeComprobante=\"ingreso\" total=\"$sale_total_cost\" subTotal=\"$sale_subtotal\" $xml_descuento certificado=\"$certificado\" noCertificado=\"$serie_cert\" formaDePago=\"$tipo_pago_desc\" metodoDePago=\"$metodo_pago\" $display_digitos_cuenta sello=\"\" folio=\"$folio\" fecha=\"$nowdt\" version=\"3.2\" xsi:schemaLocation=\"http://www.sat.gob.mx/cfd/3  http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv32.xsd\">
<cfdi:Emisor nombre=\"$invoicer\" rfc=\"$invoicer_rfc\">
    <cfdi:DomicilioFiscal calle=\"$invoicer_street\" noExterior=\"$invoicer_no_exter\" colonia=\"$invoicer_colony\" municipio=\"$invoicer_delegation\" estado=\"$invoicer_state_name\" pais=\"$invoicer_country\" codigoPostal=\"$invoicer_cp\" />
    <cfdi:ExpedidoEn calle=\"$invoicer_street\" noExterior=\"$invoicer_no_exter\" colonia=\"$invoicer_colony\" localidad=\"$invoicer_delegation\" estado=\"$invoicer_state_name\" pais=\"$invoicer_country\" codigoPostal=\"$invoicer_cp\" />
	<cfdi:RegimenFiscal Regimen=\"Regimen General\"/>
 </cfdi:Emisor>
  <cfdi:Receptor nombre=\"$customer_name_p\" rfc=\"$customer_rfc_p\">
    <cfdi:Domicilio calle=\"$customer_street_address_p\" noExterior=\"$customer_num_ext\" noInterior=\"$customer_num_int\" colonia=\"$customer_col_p\" localidad=\"$customer_del_p\" estado=\"$customer_state_name_p\" pais=\"MEXICO\" codigoPostal=\"$customer_cp\" />
  </cfdi:Receptor>
  <cfdi:Conceptos>\r";

$enies = array('Ñ', 'ñ');
$enes = array('N', 'n');
if ($tipo_pago==2)
	{	
		$item_name_pc='';
		
		while($row = mysqli_fetch_array($sales_items_result))
			{
				$quantity_purchased=$row['quantity_purchased'];
				$temp_aname=trim($row['temp_name']);
				$item_id=$row['id'];
				$item_name=trim($row['item_name']);
				
				if ($item_name=="ARTICULO TEMPORAL")
					{
						$item_name=$temp_aname; 
					}
				# Reglas de parseo XML
				$item_name_p=$dbf->validXMLdata(str_replace($enies,$enes,$item_name));
				
			$item_name_pc = "$item_name_pc"." $item_name_p";
			$unitario=$advance*$cfg_default_tax_rate/100+$advance;
			$unitario_f=number_format($unitario,2,'.','');
				
			}
			$item_name_pc_t= trim($item_name_pc);
			$xml_output .= "    <cfdi:Concepto cantidad=\"1\" descripcion=\"$item_name_pc_t\" valorUnitario=\"$advance\" importe=\"$advance\" unidad=\"PZ\" />\r";
			
	}
	
elseif ($tipo_pago==5)
	{
		$item_name_p='Articulos segun notas de venta: ' . $f_cons;
		$quantity_purchased=1;
		# Reglas de parseo XML
		$item_name_pr=$dbf->validXMLdata(str_replace($enies,$enes,$item_name_p));
    	$xml_output .= "    <cfdi:Concepto cantidad=\"$quantity_purchased\" descripcion=\"$item_name_pr\" valorUnitario=\"$sale_subtotal\" importe=\"$sale_subtotal\" unidad=\"PZ\" />\r";
	}
				
else
	{	
		while($row = mysqli_fetch_array($sales_items_result))
			{
				$quantity_purchased=$row['quantity_purchased'];
				$item_name=trim($row['item_name']);
				$item_unit_price=number_format($row['item_unit_price'],2,'.','');
				$item_total_cost=number_format($row['item_total_cost'],2,'.','');
				$temp_aname=trim($row['temp_name']);
				$item_id=$row['id'];
				
				if ($item_name=="ARTICULO TEMPORAL")
					{
						$item_name=$temp_aname; 
					}
				# Reglas de parseo XML
				$temp_aname_p=$dbf->validXMLdata($temp_aname);
				$item_name_p=$dbf->validXMLdata(str_replace($enies,$enes,$item_name));
				
				$xml_output .= "    <cfdi:Concepto cantidad=\" $quantity_purchased\" descripcion=\"$item_name_p\" valorUnitario=\"$item_unit_price\" importe=\"$item_total_cost\" unidad=\"PZ\" />\r";
				
			}

	}			
	
$xml_output .= "  </cfdi:Conceptos>\r";

# Aplica el IVA para el parseo de los impuestos	en anticipo
if ($tipo_pago==2)
{
	$taxa=($advance*$cfg_default_tax_rate/100);
	$taxaf=number_format($taxa,2,'.','');
}

$total_tax = $sale_total_cost-$sale_subtotal;
$total_tax_f = number_format($total_tax,2,'.','');
if ($tipo_pago==2)
{
	$xml_output .= "  <cfdi:Impuestos totalImpuestosTrasladados=\"$total_tax_f\">
		<cfdi:Traslados>\r";
}
else
{
	$xml_output .= "  <cfdi:Impuestos totalImpuestosTrasladados=\"$total_tax_f\">
   		<cfdi:Traslados>\r";
}

if ($tipo_pago==2)
	{
	$xml_output .="      <cfdi:Traslado impuesto=\"IVA\" tasa=\"$cfg_default_tax_rate\" importe=\"$taxaf\" />\r";
	}
elseif ($tipo_pago==5)
	{
		$taxa=($sale_subtotal*$cfg_default_tax_rate/100);
		$taxaf=number_format($taxa,2,'.','');
		$xml_output .="      <cfdi:Traslado impuesto=\"IVA\" tasa=\"$cfg_default_tax_rate\" importe=\"$taxaf\" />\r";
	}
else
	{		
		while($row = mysqli_fetch_array($tax_items_result))
			{
				$item_id=$row['item_id'];
				$item_unit_price =$row['item_unit_price'];
				$item_quantity_purchased =$row['quantity_purchased'];	
				$taxa=($item_unit_price*$cfg_default_tax_rate/100)*$item_quantity_purchased;
				$taxaf=number_format($taxa,2,'.','');
				$xml_output .="      <cfdi:Traslado impuesto=\"IVA\" tasa=\"$cfg_default_tax_rate\" importe=\"$taxaf\" />\r";
			}
	}		

$xml_output .="    </cfdi:Traslados>
  </cfdi:Impuestos>
</cfdi:Comprobante>";

echo $xml_output;
?> 