<?php 
//=======================================
// App Name:e-invox V 0.1
// File Name: xml_ppd_3-3.php
//---------------------------------------
// Description: 
// XML parser para CFDI PPD
//=======================================
// Author:  Angel Roberto Hernández
//---------------------------------------
// Contact: ahernandez@postech.com.mx
// http://www.postech.com.mx
//=======================================

session_start();
date_default_timezone_set('UTC');

include ("../../settings.php");
include ("../../language/$cfg_language");
include ("../../classes/db_functions.php");
include ("../../classes/security_functions.php");


$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Public',$lang);

$ppd_id= $_REQUEST['ppdid'];
//$sale_id= $_REQUEST['saleid'];
$sales_table = $cfg_tableprefix.'sales';
$sales_ppd_table = $cfg_tableprefix.'sales_ppd';
//$sales_items_table = $cfg_tableprefix.'sales_items';
$customers_table = $cfg_tableprefix.'sales_customers';
$invoicer_table = $cfg_tableprefix.'invoicer';
$states_table = $cfg_tableprefix.'states';
//$items_table = $cfg_tableprefix.'items';
$branch_table = $cfg_tableprefix.'branches';
$c_ClaveProdServ_table = $cfg_tableprefix.'c_ClaveProdServ';
$c_ClaveUnidad_table = $cfg_tableprefix.'c_ClaveUnidad';
$c_UsoCFDI_table = $cfg_tableprefix.'c_UsoCFDI';
$item_iva_tax = 0.160000;

// Datos de parcialidad
$sales_ppd_result = mysqli_query($dbf->conn,"SELECT * from $sales_ppd_table WHERE id=$ppd_id") or die("No existen coincidencias para la venta num $ppd_id.");
while($row = mysqli_fetch_array($sales_ppd_result))
{
	/*
	echo "<pre>";
	print_r($row);
	echo "</pre>";
	die;
	*/
	$sale_id=$row["sale_id"];
	$parcialidad=$row["parcialidad"];
	$fecha_pago=str_replace(" ", "T", $row["fecha_pago"]);
	$paid_with_ppd=$row["paid_with"];
	$monto=$row["monto"];
	$original_string=$row["cadena_original"];
	$sello=$row["sello"];
	$timbre_fiscal=$row["timbre_fiscal"];
	$sello_sat=$row["sello_sat"];
	$parent_UUID=$row["parent_UUID"];
	$serie=$row["serie"];
	$folio=$row["folio"];
	$saldo_anterior=$row["saldo_anterior"];
	$pagado=$row["pagado"];
	$saldo=$row["saldo"];
}


// Datos de venta
$sale_result = mysqli_query($dbf->conn,"SELECT * from $sales_table WHERE id=$sale_id") or die("No existen coincidencias para la venta num $sale_id.");

while($row = mysqli_fetch_array($sale_result))
{
	$tipo_pago=$row["tipo_pago"];
	$folio=$row["folio"];
	$datef=$row["date"];
	$timef=$row["sale_time"];
	$sale_subtotal=$row["sale_sub_total"];
	$sale_total_cost=$row["sale_total_cost"];
	$advance=$row["advance"];
	$datetimef="$datef$timef";
	$original_string=$row["cadena_original"];
	//$sello=$row["sello"];
	$discount=$row["discount"];
	$paid_with = $row["paid_with"];
	//$digitos_cuenta = $row["digitos_cuenta"];
	//$uso_cfdi = $row["uso_cfdi"];
	$uso_cfdi=$dbf->idToField($c_UsoCFDI_table,'c_UsoCFDI',$row["uso_cfdi"]);
	$invoicer_branch_cp=$dbf->idToField($branch_table,'cp',$row["branch_id"]);
}

# detalle de venta
/*
$sales_items_result = mysqli_query($dbf->conn,"SELECT $sales_items_table.sale_id, $sales_items_table.quantity_purchased, $sales_items_table.item_unit_price, $sales_items_table.item_total_cost, $sales_items_table.temp_name, $sales_items_table.afecta, $sales_items_table.branch_id, $sales_items_table.discount, $items_table.item_name, $items_table.item_number, $items_table.description, $items_table.c_ClaveProdServ_id, $items_table.c_ClaveUnidad_id, $items_table.id FROM $sales_items_table JOIN $items_table ON $sales_items_table.item_id = $items_table.id WHERE $sales_items_table.sale_id = $sale_id order by $sales_items_table.id");
*/

# datos folios
$folios_header_result =mysqli_query($dbf->conn,"SELECT * FROM folios_header");

while($row = mysqli_fetch_array($folios_header_result))
{
	$ano_aprob=trim($row["ano_aprob"]);
	$serie_cert=trim($row["serie_cert"]);
	$num_aprob=trim($row["num_aprob"]);
	$certificado=trim($row["certificado"]);
}

# detalle de impuesto trasladado
/*
$tax_items_result = mysqli_query($dbf->conn,"SELECT item_unit_price, item_total_cost, quantity_purchased,item_id FROM $sales_items_table WHERE sale_id = $sale_id order by $sales_items_table.id");
*/

# datos de cliente
$customer_result = mysqli_query($dbf->conn,"SELECT * FROM $customers_table WHERE sale_id = $sale_id");
while($row = mysqli_fetch_array($customer_result))
{
	$customer_nameo=$row["name"];
	$customer_rfco=$row["rfc"];
	$customer_street_addresso=$row["street_address"];
	$customer_num_exto=$row["num_ext"];
	$customer_num_int=$row["num_int"];
	$customer_col=$row["col"];
	$customer_del=$row["del"];
	$customer_city=$row["city"];
	$customer_state_id=$row["state_id"];
	$customer_cp=$row["cp"];
	$customer_num=$row["id"];
}

#Quitamos espacion en blanco e innecesarios
$customer_name = trim($customer_nameo);
$customer_rfc = trim($customer_rfco);
$customer_street_address = trim($customer_street_addresso);
$customer_num_ext = trim($customer_num_exto);
$customer_state_name = $dbf->idToField($states_table,'state',$customer_state_id);

#si el numero interior esta vacio coloca una coma
if(empty($customer_num_int))
{
	$customer_num_int=",";
}

# datos de emisor fiscal
$invoicer_result = mysqli_query($dbf->conn,"SELECT * from $invoicer_table") or die("No existen informacion del emisor fiscal");
while($row = mysqli_fetch_array($invoicer_result))
{
	$invoicer=$row["razon_social"];
	$invoicer_rfc=$row["rfc"];
	$invoicer_street=$row["street"];
	$invoicer_no_exter=$row["no_exter"];
	$invoicer_no_inter=$row["no_inter"];
	$invoicer_colony=$row["colony"];
	$invoicer_delegation=$row["delegation"];
	$invoicer_cp=$row["cp"];
	$invoicer_country=$row["country"];
	$invoicer_city=$row["city"];
	$invoicer_state_id=$row["state_id"];
	$invoicer_phone_number=$row["phone_number"];
	$invoicer_id=$row["id"];
}
$invoicer_state_name = $dbf->idToField($states_table,'state',$invoicer_state_id);

# Reglas de parseo para formato de xml
$customer_name_p = trim($dbf->validXMLdata($customer_name));
$customer_rfc_p = trim($dbf->validXMLdata($customer_rfc));
$customer_street_address_p = trim($dbf->validXMLdata($customer_street_address));
$customer_col_p = trim($dbf->validXMLdata($customer_col));
$customer_del_p = trim($dbf->validXMLdata($customer_del));
$customer_city_p = trim($dbf->validXMLdata($customer_city));
$customer_state_name_p = trim($dbf->validXMLdata($customer_state_name));
$nowdt=$datef."T".$timef;

header("Content-type: text/xml");

$metodo_pago = $paid_with;

/*
$enies = array('Ñ', 'ñ');
$enes = array('N', 'n');
/*
$RfcEmisorCtaOrd="XEXX010101000";
$NomBancoOrdExt="BANK OF MEXICO";
$CtaOrdenante="1234567890";
if ($RfcEmisorCtaOrd && $NomBancoOrdExt && $CtaOrdenante)
{
	$dataOrdenante = " RfcEmisorCtaOrd=\"$RfcEmisorCtaOrd\" NomBancoOrdExt=\"$NomBancoOrdExt\" CtaOrdenante=\"$CtaOrdenante\" ";
}
*/

$xml_output = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r";

$xml_output .= "
<cfdi:Comprobante xmlns:cfdi=\"http://www.sat.gob.mx/cfd/3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:pago10=\"http://www.sat.gob.mx/Pagos\" xsi:schemaLocation=\"http://www.sat.gob.mx/cfd/3 http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv33.xsd http://www.sat.gob.mx/Pagos http://www.sat.gob.mx/sitio_internet/cfd/Pagos/Pagos10.xsd\" Version=\"3.3\" Serie=\"$serie\" Folio=\"$ppd_id\" Fecha=\"$fecha_pago\" Sello=\"\" NoCertificado=\"$serie_cert\" Certificado=\"$certificado\" SubTotal=\"0\" Moneda=\"XXX\" Total=\"0\" TipoDeComprobante=\"P\" LugarExpedicion=\"$invoicer_branch_cp\">\r
	<cfdi:Emisor Rfc=\"$invoicer_rfc\" Nombre=\"$invoicer\" RegimenFiscal=\"601\" />\r
	<cfdi:Receptor Rfc=\"$customer_rfc_p\" Nombre=\"$customer_name_p\" UsoCFDI=\"P01\" />\r
	<cfdi:Conceptos>\r
		<cfdi:Concepto ClaveProdServ=\"84111506\" Cantidad=\"1\" ClaveUnidad=\"ACT\" Descripcion=\"Pago\" ValorUnitario=\"0\" Importe=\"0\" />\r
	</cfdi:Conceptos>\r";

$xml_output .= "
	<cfdi:Complemento>
		<pago10:Pagos Version=\"1.0\">
			<pago10:Pago FechaPago=\"$fecha_pago\" FormaDePagoP=\"$paid_with_ppd\" MonedaP=\"MXN\" Monto=\"$pagado\"".$dataOrdenante.">
				<pago10:DoctoRelacionado IdDocumento=\"$parent_UUID\" MonedaDR=\"MXN\" MetodoDePagoDR=\"PPD\" NumParcialidad=\"$parcialidad\" ImpSaldoAnt=\"$saldo_anterior\" ImpPagado=\"$pagado\" ImpSaldoInsoluto=\"$saldo\"/>
			</pago10:Pago>
		</pago10:Pagos>
	</cfdi:Complemento>";

$xml_output .= "
</cfdi:Comprobante>";

/*
<tfd:TimbreFiscalDigital xmlns:tfd=\"http://www.sat.gob.mx/TimbreFiscalDigital\" xsi:schemaLocation=\"http://www.sat.gob.mx/TimbreFiscalDigital http://www.sat.gob.mx/sitio_internet/cfd/TimbreFiscalDigital/TimbreFiscalDigitalv11.xsd\" Version=\"1.1\" UUID=\"C2B4AEFA-884A-44A9-8CF5-41318452420E\" FechaTimbrado=\"2017-10-31T17:13:55\" RfcProvCertif=\"SFE0807172W7\" SelloCFD=\"BSs55N7PWJW6x2oGkab7Z5U7cpcrOnwdWeaPcculHkaNl2FwUolyZmOozSXIv232VBr98+AiVkTFLD/dcJU0o7p+bYyQ9UHZVoTi0EU0Pnpx26/bEEfV55Npq1Hl14HmFE1J+YwBlCcRSLZTSKVLBj8jH5oahlJlJOH6VTf/L+RePqqCvYjSoeaohUj5f6vspJUz7roB6CzFjzTdinesAz3HY/2xVwlZE2Kra/8Pa8mQkvquRU+yP1H733h8UGujpWYOxk3H6P1EPVQ53+ATDm08lESrOIh78ONgKNID8xPRWrBJ3CzzqpcPBfIneSwY73QFNX83eF/KRN9uG9UWQA==\" NoCertificadoSAT=\"20001000000300022779\" SelloSAT=\"CGzUE1oOcQ1K3FbMt6+e1TrBRXu0hSTqhcVozApdMziAfcIpRCujWOhEMVycxBrK3Z8UQ0rtyaPxwDoGXaeu4weOsihRIg6uoZL3fgifOnM5grMPcHbe3S6heExdV+0u7ova03jPxibVg6etDzhYvl3lynTUJne/VZ6YvrkLDnzOCC9ZCWIqEmsUq5PbqhqXuTw83Gq9QWfkaV4NJt/q9lEwpkoFXpHNYF4RmkfhvQgT8Y58JlkQ39YLY03LVsTnlnI0IEWhPo2bEdTq72BwIT3GeY/8ZYIPKD+lHw+2mZOR8r58QVxgkfAx+jUc6zr+1AaDfveciK9hxwxbZndrcw==\" />
*/
echo $xml_output;
?> 