<?php 
session_start(); 
error_reporting(0);

include ("../settings.php");
include ("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/form.php");
include ("../classes/display.php");

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Sales Clerk',$lang);
$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);


if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit();
}

$sales_items_tableheaders=array("ID","No. Parcialidad","Forma de Pago","Pago","Saldo","Imprimir Documento","Descargar XML");
$sales_items_tablefields=array('sale_id','parcialidad','paid_with','pagado','saldo','cfdi','xml');

if(isset($_GET['sale_id']))
{
	$sale_items_query="SELECT * FROM sales_ppd WHERE sale_id = ".$_GET['sale_id'];
	echo "
		<div class='table-responsive'>
			<table class='table table-striped'>
				<thead>
					<tr>";
	for($k=0;$k<count($sales_items_tableheaders);$k++)
	{
		echo "
						<th>".$sales_items_tableheaders[$k]."</th>";
	}
	echo "
					</tr>
				</thead>
				<tbody>";
			
	$sale_items_result=mysqli_query($dbf->conn,$sale_items_query);
	while($newrow=mysqli_fetch_assoc($sale_items_result))
	{
		$ppd_id = $newrow['id'];
		echo "
					<tr>";
		for($k=0;$k<count($sales_items_tablefields);$k++)
		{
			$field=$sales_items_tablefields[$k];
			$field_=in_array($field, array("pagado", "saldo")) ? "amount" : $field;
			$data=$display->formatData($field_,$newrow[$field],$cfg_tableprefix);
			echo "
						<td>";

			switch($field)
			{
				case 'cfdi' : echo "<a href='http://contenur.com.mx/csc/sales/docs/ppd_3-3.php?ppdid=$ppd_id' target='_blank'>CFDI</a>";
				break;
				case 'xml' : echo "<a href='sales/docs/generate_download_cfd.php?ppdid=$ppd_id&amp;download=down' target='_blank'>XML</a>";
				break;
				//case 'saldo' : case 'pagado' : echo $display->formatData('amount',$data,$tableprefix);
				//break;
				default: echo $data;
				break;
			}
			echo "</td>";
		}
		echo "
					</tr>";
	}
	echo "
				</tbody>
				<tfoot>";

	echo "
				</tfoot>
			</table>
		</div>";
}