<?php 
session_start();
date_default_timezone_set('America/Mexico_City');

include ("../settings.php");
include ("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/form.php");
include ("../classes/display.php");

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Admin',$lang);
$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);

if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit();
}

$first_name_value='';
$last_name_value='';
$username_value='';
$type_value='';
$password_value='';
$imss_value='';
$rfc_value='';
$fecha_ingreso_value='';
$salario_value='';
$branch_id_value='';
$status_value='';
$id=-1;
$todaysDate = date ('Y-m-d');
if(isset($_GET['action']))
{
	$action=$_GET['action'];
}
else
{
	$action="insert";
}
if($action=="update")
{
	$title_form = $lang->updateUser;
	if(isset($_GET['id']))
	{
		$id=$_GET['id'];
		$tablename = $cfg_tableprefix.'users';
		$result = mysqli_query($dbf->conn,"SELECT * FROM $tablename WHERE id=\"$id\"");
		$row = mysqli_fetch_assoc($result);
		$first_name_value=$row['first_name'];
		$last_name_value=$row['last_name'];
		$username_value=$row['username'];
		$password_value="*notchanged*";
		$type_value=$row['type'];
		$imss_value=$row['imss'];
		$rfc_value=$row['rfc'];
		$todaysDate=$row['fecha_ingreso'];
		$branch_id_value=$row['branch_id'];
		$salario_value=$row['salario'];
		$status_value=$row['status'];
		$email_value=$row['email'];
		$signature_value=$row['signature'];

		$required = true;
	}
}
else
{
	$title_form = $lang->addUser;
}	
$f1=new form('index.php','POST','users',$title_form,$lang,true);
$f1->createInputField($lang->firstName,'text','first_name',$first_name_value,NULL,true);
$f1->createInputField($lang->lastName,'text','last_name',$last_name_value,"col_last",true);
$f1->createInputField($lang->username." <i>($lang->usedInLogin)</i>",'text','username',$username_value,NULL,true);

$option_values=array($type_value,'Admin','Sales Clerk','Report Viewer',"Empleado");
$option_titles=array($type_value,"Admin","Sales Clerk","Report Viewer","Empleado");
//$option_titles=array("$type_value","$lang->admin","$lang->salesClerk","$lang->reportViewer");
$f1->createSelectField("<b>$lang->type:</b> ",'type',$option_values,$option_titles,"col_last");

$f1->createInputField($lang->password,'password','password',$password_value,NULL,true,true);
$f1->createInputField($lang->confirmPassword,'password','cpassword',$password_value,"col_last",true);

$branchtable = $cfg_tableprefix.'branches';
$branches_option_titles=$dbf->getAllElements($branchtable,'branch_name','branch_name');
array_unshift($branches_option_titles,$dbf->idToField($branchtable,'branch_name',$branch_id_value));
$branches_option_values=$dbf->getAllElements($branchtable,'id','branch_name');
array_unshift($branches_option_values,$branch_id_value);
$f1->createSelectField($lang->branch,'branch_id',$branches_option_values,$branches_option_titles,NULL);

$f1->createInputField("IMSS",'imss','imss',$imss_value,"col_last");
$f1->createInputField("RFC",'rfc','rfc',$rfc_value,NULL);
$f1->createInputField($lang->startDate,'date','date',$todaysDate,"col_last",true);
$f1->createInputField($lang->salary,'salario','salario',$salario_value,NULL);

$option_values=array($status_value,'Activo','Inactivo');
$option_titles=array($status_value,"Activo","Inactivo");
$f1->createSelectField($lang->status,'status',$option_values,$option_titles,"col_last",true);

$f1->createInputField($lang->email,'email','email',$email_value,NULL);
$f1->createInputField("Firma del correo",'file','img',"","col_last",!$required,false,"onChange=\"valida(this.value,this.id);\"");

echo "
	<input type='hidden' name='img2' value='$signature_value'>
	<input type='hidden' name='action' value='$action'>
	<input type='hidden' name='id' value='$id'>";
echo "
	<input type='hidden' name='path_id' value='users/process_form_users'>";
$f1->endForm();
?>